<?php

function errorLogSQL($error, $mensaje = '', $valores = array()){
    $archivo_log = rutaArchivo('conf/error-sql.log');
    $txt_mensaje = '';

    if(!empty($mensaje))
        $txt_mensaje .= "{$mensaje}: ";

    $contenido = json_encode(array(
        'mensaje'   => $mensaje,
        'error'     => $error,
        'valores'   => $valores,
        'fecha'     => fechaHoraActual()
    )) . "\n";

    crearArchivo($archivo_log, $contenido, 'a');

    $valores = (!empty($valores))? implode(', ', $valores) : '--';

    notificarError(
        "<b>¡ERROR SQL! </b>\n\n"
        . "<b>Sitio</b>\n" . _DIR_ . "\n\n"
        . "<b>Archivo</b>\n" . get_included_files()[0] . "\n\n"
        . "<b>Mensaje</b>\n{$mensaje}\n\n"
        . "<b>Descripción</b>\n{$error}\n\n"
        . "<b>Valores</b>\n" . $valores
    );

    /*$mensaje_error = (_sesionActiva() && _esAdmin())? "Error ({$mensaje})<br>{$error}"
        : 'Ha ocurrido un error.<br>Favor consultar con el encargado.';*/

    $mensaje_error = "Error ({$mensaje})<br>{$error}";

    echo $mensaje_error;
    require vaciarVariable();
    exit;
}
