<?php

$ruta_proyecto = '/var/www/html/lighthouse/';
//$ruta_proyecto = '../../';
require 'funciones-aux.php';

$ruta_cron  = $ruta_proyecto .'cron/';
$ruta_clase = $ruta_proyecto .'clases/';
$ruta_conf  = $ruta_proyecto .'conf/';

require $ruta_cron  . 'funciones-cron.php';
require $ruta_conf  . 'propiedades.php';
require $ruta_clase . 'conexion-class.php';
require $ruta_clase . 'lighthouse-class.php';

$_lighthouse    = new Lighthouse();

$_lighthouse->filtro            = '-score';
$_lighthouse->dias_atras        = 6;

$correos_a_enviar = array(
    	'dsepulveda@calper.cl',
	'roberto@calper.cl',
	'cperezu@calper.cl',
	'dmorales@calper.cl',
	'jrojas@calper.cl'
);

$arial                          = 'font-family: Arial;';
$borde                          = 'border:1px solid #ddd;';
$estilo_th                      = $borde . 'background-color:#f1f1f1; text-align:left; color:#666; padding:8px 10px;';
$estilo_td                      = $borde . 'color:#666; padding:5px;';
$estilo_seo                     = 'background-color:#05f5f9;';
$estilo_rendimiento             = 'background-color:#63f9fb;';
$estilo_accesibilidad           = 'background-color:#a1fbfd;';
$estilo_practicas_recomendadas  = 'background-color:#c1fcfd;';
$estilo_pwa                     = 'background-color:#e0fefe;';
$estilo_error                   = 'background-color:#FB8341;';
$html   = $html2 = $html3       = '';


$estadisticas = $_lighthouse->BuscarScoreGeneral();

$arr_url1 = $arr_url2 = $arr_url3 = $arr_sin_arr = array();

foreach($estadisticas as $e){
    if($e->id_requestedUrl == 1){
        $arr_url1[]     = $e;
    }elseif($e->id_requestedUrl == 2){
        $arr_url2[]     = $e;
    }elseif($e->id_requestedUrl == 3){
        //$arr_url3[]     = $e; //url de trakea tu pedido
    }else{
        $arr_sin_arr    = $e;
    }
}
for($i=0;$i<2;++$i){
    if($i == 0){
        $url_aux = $arr_url1;
    }elseif($i == 1){
        $url_aux = $arr_url2;
    }else{
        $url_aux = array();
    }

    $arr_movil = $arr_desktop = $arr_sin_dispositivo = array();

    foreach($url_aux as $au){
        if($au->id_tipo_dispositivo == 1){
            $arr_desktop[]=$au;
        }elseif($au->id_tipo_dispositivo == 2){
            $arr_movil[]=$au;
        }else{
            $arr_sin_dispositivo[] = $au;
        }
    }

    $arr_seo = $arr_rendimiento = $arr_accesibidad = $arr_practicas_recomendadas = $arr_pwa = $arr_sin_categoria = array();
    foreach($arr_desktop as $ad){
        if($ad->category == 'SEO'){
            $arr_seo[] = $ad;
        }elseif($ad->category == 'Rendimiento'){
            $arr_rendimiento[] = $ad;
        }elseif($ad->category == 'Accesibilidad'){
            $arr_accesibidad[] = $ad;
        }elseif($ad->category == 'Prácticas recomendadas'){
            $arr_practicas_recomendadas[] = $ad;
        }elseif($ad->category == 'PWA'){
            $arr_pwa[] = $ad;
        }else{
            $arr_sin_categoria[]= $ad;
        }
    }

    $ver_seo                        = mostrarDetalle($arr_seo);
    $ver_rendimiento                = mostrarDetalle($arr_rendimiento);
    $ver_accesibilidad              = mostrarDetalle($arr_accesibidad);
    $ver_practicas_recomendadas     = mostrarDetalle($arr_practicas_recomendadas);
    $ver_pwa                        = mostrarDetalle($arr_pwa);

    $arr_seo_movil = $arr_rendimiento_movil = $arr_accesibidad_movil = $arr_practicas_recomendadas_movil = $arr_pwa_movil = $arr_sin_categoria_movil = array();
    foreach($arr_movil as $am){
        if($am->category == 'SEO'){
            $arr_seo_movil[] = $am;
        }elseif($am->category == 'Rendimiento'){
            $arr_rendimiento_movil[] = $am;
        }elseif($am->category == 'Accesibilidad'){
            $arr_accesibidad_movil[] = $am;
        }elseif($am->category == 'Prácticas recomendadas'){
            $arr_practicas_recomendadas_movil[] = $am;
        }elseif($am->category == 'PWA'){
            $arr_pwa_movil[] = $am;
        }else{
            $arr_sin_categoria_movil[]= $am;
        }
    }

    $ver_seo_movil                        = mostrarDetalle($arr_seo_movil);
    $ver_rendimiento_movil                = mostrarDetalle($arr_rendimiento_movil);
    $ver_accesibilidad_movil              = mostrarDetalle($arr_accesibidad_movil);
    $ver_practicas_recomendadas_movil     = mostrarDetalle($arr_practicas_recomendadas_movil);
    $ver_pwa_movil                        = mostrarDetalle($arr_pwa_movil);

    $cabecera = "<table style='{$borde}{$arial}width:100%' cellpadding='0' cellspacing='0'>"
            . '<tr>'
                . "<td style='{$estilo_th}width:25%'>Url Origen</td>"
                . "<td style='{$estilo_th}'>Categoria</td>"
                . "<td style='{$estilo_th}'>Titulo</td>"
                . "<td style='{$estilo_th}'>Puntaje</td>"
                . "<td style='{$estilo_th}'>Fecha Registro</td>"
            . '</tr>';

    $style          = $estilo_td . $estilo_seo;
    $style_error    = $estilo_td . $estilo_error;
    if(!empty($arr_seo)){
        $html3 .= $cabecera;
    }
    if(!empty($arr_seo_movil)){
        $html2 .= $cabecera;
    }
    
    
        if(!empty($arr_seo)){
            $html3      .= armarTablaHTML($arr_seo,  $style, $style_error, $ver_seo);
        }
        if(!empty($arr_seo_movil)){
            $html2      .= armarTablaHTML($arr_seo_movil,  $style, $style_error, $ver_seo_movil);
        }
               
    $style          = $estilo_td . $estilo_rendimiento;
        if(!empty($arr_rendimiento)){
            $html3      .= armarTablaHTML($arr_rendimiento,  $style, $style_error, $ver_rendimiento);
        }
        if(!empty($arr_rendimiento_movil)){
            $html2      .= armarTablaHTML($arr_rendimiento_movil,  $style, $style_error, $ver_rendimiento_movil);
        }
        
    $style          = $estilo_td . $estilo_accesibilidad;
        if(!empty($arr_accesibidad)){
            $html3      .= armarTablaHTML($arr_accesibidad,  $style, $style_error, $ver_accesibilidad);
        }
        if(!empty($arr_accesibidad_movil)){
            $html2      .= armarTablaHTML($arr_accesibidad_movil,  $style, $style_error, $ver_accesibilidad_movil);
        }
        
    $style          = $estilo_td . $estilo_practicas_recomendadas;
        if(!empty($arr_practicas_recomendadas)){
            $html3      .= armarTablaHTML($arr_practicas_recomendadas,  $style, $style_error, $ver_practicas_recomendadas);
        }
        if(!empty($arr_practicas_recomendadas_movil)){
            $html2      .= armarTablaHTML($arr_practicas_recomendadas_movil,  $style, $style_error, $ver_practicas_recomendadas_movil);
        }

    $style          = $estilo_td . $estilo_pwa;
        if(!empty($arr_pwa)){
            $html3      .= armarTablaHTML($arr_pwa,  $style, $style_error, $ver_pwa); 
        }
        if(!empty($arr_pwa_movil)){
            $html2      .= armarTablaHTML($arr_pwa_movil,  $style, $style_error, $ver_pwa_movil);
        }
    $html3 .= '</table><br>';
    $html2 .= '</table><br>';
        
         
}
//Tabla Desktop
$html .= '<br>'
        . '<table style="font-family: Arial; text-align:center; color:#666; width:100%">'
            . '<tr><td style="text-align:center; font-size: 30px">Estadísticas Escritorio</td></tr>'
        . '</table>'
    . $html3;      

//Tabla Movil
$html .= '<table style="font-family: Arial; text-align:center; color:#666; width:100%">'
            . '<tr><td style="text-align:center; font-size: 30px">Estadisticas Movil</td></tr>'
        . '</table>'
        . $html2;

$archivo = '';

$enviado        = enviarCorreo(
    'b2b@calper.cl',
    'Lighthouse',
    'Reporte Lighthouse',
    _IMG_CORREO_,
    'Reporte Lighthouse',
    $correos_a_enviar, // array('dsepulveda@calper.cl', 'roberto@calper.cl'),
    //(!_TEST_)? array('fperezu@calper.cl', 'cperezu@calper.cl', $correo_envio) : array('encargado_web@calper.cl'),
    $html,
    array($archivo)
);

echo ($enviado)? 'Correo enviado' : 'No se envió el correo';
