<?php

//$ruta_base = rutaCarpeta('../funciones/');
require $ruta_proyecto . 'funciones/funciones-escenciales.php';

function rutaArchivo($archivo){
    $cont = 0;
    while(!existeArchivo($archivo) && $cont < 5){
        $archivo = "../{$archivo}";
        ++$cont;
    }

    return $archivo;
}

function existeArchivo($ruta_archivo){
    return file_exists($ruta_archivo);
}

function url($carpeta = '', $forwarded_host = false) {
    try{
        $ruta = '';

        if(isset($_SERVER['SERVER_PROTOCOL'])){
            $ssl   = !empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on';
            $proto = strtolower($_SERVER['SERVER_PROTOCOL']);
            $proto = substr($proto, 0, strpos($proto, '/')) . ($ssl ? 's' : '');
            if( $forwarded_host && isset($_SERVER['HTTP_X_FORWARDED_HOST'])){
                $host = $_SERVER['HTTP_X_FORWARDED_HOST'];
            } else {
                if(isset($_SERVER['HTTP_HOST'])){
                    $host = $_SERVER['HTTP_HOST'];
                }else{
                    $port = $_SERVER['SERVER_PORT'];
                    $port = ((!$ssl && $port == '80') || ($ssl && $port == '443' ))? '' : ':' . $port;
                    $host = $_SERVER['SERVER_NAME'] . $port;
                }
            }

            if(!empty($carpeta))
                $carpeta .= '/';

            $ruta = "{$proto}://{$host}/{$carpeta}";
        }

        return $ruta;
    }catch(Exception $e){
        return '--';
    }
}

function vaciarVariable(){
    $archivo = rutaArchivo('../core/inc/vaciar-variable.php');
    return (existeArchivo($archivo))? $archivo : false;
}

function cambiarFecha($fecha, $formato = 'Y-m-d', $tiempo_modificar = '-0 seconds'){
    return date($formato, strtotime($tiempo_modificar, strtotime($fecha)));
}

function fechaHoraActual($formato = 'Y-m-d H:i:s'){
    return cambiarFecha(date($formato), $formato, _AJUSTE_HORA_);
}

function crearArchivo($archivo, $contenido, $opcion = 'w'){
    $fp = fopen($archivo, $opcion);
    fwrite($fp, $contenido);
    fclose($fp);

    return true;
}

function notificarError($mensaje, $chat_id = 1661523431){
    /*if(!class_exists('Apic')){
        $dir_api = rutaArchivo('comun/clases/api-class.php');
        if(existeArchivo($dir_api))
            require $dir_api;
        else
            return false;
    }*/

   /* if(!class_exists('Telegram')){
        $dir_telegram = rutaArchivo('comun/clases/telegram-class.php');
        if(existeArchivo($dir_telegram))
            require $dir_telegram;
        else
            return false;
    }*/

    //if(_TEST_)
        $mensaje = "(TEST)\n" . $mensaje;

    //return (new Telegram($chat_id))->EnviarMensaje($mensaje);
}

function sClass(){
    return new stdClass();
}

function nuloIgualVacio($valor){
    return ($valor === NULL)? '' : $valor;
}

function vacioIgualNulo($valor){
    return (!empty(trim($valor)))? $valor : NULL;
}

function numeroONulo($valor){
    return ($valor === 0 || $valor > 0)? $valor : NULL;
}

function vacioIgualGuion($valor, $agregado_inicio = '', $agregado_final = ''){
    if(!empty($valor)){
        if(!empty($agregado_inicio))
            $valor = $agregado_inicio . $valor;

        if(!empty($agregado_final))
            $valor .= $agregado_final;
    }else
        $valor = '--';

    return $valor;
}

//require_once '../../../vendor/autoload.php'; //local
require_once '/var/www/html/lighthouse/vendor/autoload.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

//$_mail = new PHPMailer(TRUE);

function enviarCorreo($de, $remitente, $asunto, $imagen_cabecera, $titulo, $correos, $contenido, $adjunto = array(), $copia_oculta = array(), $cuenta_2 = false){
    $td_contenido = 'padding:5px 5px';

    $html = '<html>'
        . '<body style="font-family: Arial;">'
            . '<table border="0" align="center" cellpadding="0" cellspacing="0" style="width:1100px;border:1px solid #ddd">'
                . '<tr>'
                    . '<td style="background-color:#304151; text-align:center;">'
                        . '<br>'
                        . "<img src='{$imagen_cabecera}' style='height:150px;margin-bottom:10px' height='150'>"
                        . '<br>'
                        . '<h1 style="text-align:center;font-family: Arial; color:#fff; margin:8px 10px 10px">' . $titulo . '</h1>'
                    . '</td>'
                . '</tr>'
                . '<tr>'
                    . "<td style='{$td_contenido}'>{$contenido}</td>"
                . '</tr>'
            . '</table>'
        . '</body>'
    . '</html>';

    $enviado = enviarCorreoSinFormato($de, $remitente, $asunto, $correos, $html, $adjunto, $copia_oculta, $cuenta_2);

    unset($de, $remitente, $asunto, $correos, $html, $adjunto, $copia_oculta, $cuenta_2, $td_contenido, $imagen_cabecera, $titulo, $contenido);
    return $enviado;
}

function enviarCorreoSinFormato($de, $remitente, $asunto, $correos, $contenido, $adjunto = array(), $copia_oculta = array(), $cuenta_2 = false){
    
    //$_mail = new PHPMailer;

    /*if(!class_exists('PHPMailer\PHPMailer\Exception')){
        require 'PHPMailer-v2/src/Exception.php';
        require 'PHPMailer-v2/src/PHPMailer.php';
        require 'PHPMailer-v2/src/SMTP.php';
    }*/

    $_mail = new PHPMailer(TRUE);

    //$texto_test     = (_TEST_)? '[TEST] ' : '';
    $texto_test     = ' ';
    $arr_estilos    = array(
        'bg-1'          => 'background-color:#3a5675',
        'bg-2'          => 'background-color:#4682b4',
        'bg-f'          => 'background-color:#fff',
        'bg-f1'         => 'background-color:#f1f1f1',
        'color-1'       => 'color:#3a5675',
        'color-2'       => 'color:#4682b4',
        'color-f'       => 'color:#fff',
        'color-6'       => 'color:#666',
        'txt-left'      => 'text-align:left',
        'txt-center'    => 'text-align:center',
        'txt-right'     => 'text-align:right',
        'txt-just'      => 'text-align:justify',
        'arial'         => 'font-family:Arial',
        'bold'          => 'font-weight:bold',
        'w-100'         => 'width:100%'
    );

    foreach($arr_estilos as $clave => $estilo){
        $nombre     = "[--{$clave}]";
        $css        = $estilo . ';';
        $contenido  = str_replace($nombre, $css, $contenido);
    }

    unset($arr_estilos, $clave, $estilo, $nombre, $css);

    //require rutaArchivo('comun/conf/variables-correo.php');

    $_mail->isSMTP();
    $_mail->setFrom($de, $remitente);
    $_mail->SMTPAuth    = true;
    $_mail->Username    = 'b2b@calper.cl';
    $_mail->Password    = 'C4lp3r2017';

    /*$_mail->SMTPSecure  = 'tls';
    $_mail->Host        = 'smtp-relay.gmail.com';
    $_mail->Port        = 587;*/

    $_mail->SMTPSecure  = 'ssl';
    $_mail->Host        = 'smtp.gmail.com';
    $_mail->Port        = 465;

    foreach($correos as $correo)
        $_mail->addAddress($correo);

    foreach($copia_oculta as $copia)
        $_mail->AddBCC($copia);

    foreach($adjunto as $archivo){
        if(!empty($archivo))
            $_mail->addAttachment($archivo);
    }

    $_mail->isHTML(true);
    $_mail->CharSet = 'UTF-8';
    $_mail->Subject     = $texto_test . $asunto;
    $_mail->Body        = $contenido;
    //$_mail->SMTPDebug   = 1;
    $enviado            = $_mail->send();

    unset($de, $remitente, $usuario, $contrasena, $_mail, $texto_test, $asunto, $contenido, $correos, $copia_oculta, $adjunto);
    return $enviado;
}
