<?php

function rutaCarpeta($carpeta){
    $cont = 0;

    while(!is_dir($carpeta) && $cont < 5){
        $carpeta = "../{$carpeta}";

        ++$cont;
    }

    return $carpeta;
}

function mostrarDetalle($arr_datos = array()){
    $mostrar = false;
    if(!empty($arr_datos)){
        foreach($arr_datos as $ad){
            $score = $ad->score;
            foreach($arr_datos as $ad2){
                if($score != $ad2->score){
                    $mostrar = true;
                }
            }
        }
    }
    return $mostrar;
}

function armarTRAuditoria($arr_datos = array(), $style = ''){
    $html = '';
    if(!empty($arr_datos)){
        $html .= '<tr>';
        foreach($arr_datos as $ad){
            $html .="<td style='{$style}'>{$ad}</td>";    
        }
        $html .= '</tr>';
    }
    return $html;
}

function armarTablaHTML($arr_datos,  $style, $style_error, $ver_diferencia){
    $html = '';
    if($ver_diferencia == false){
        $score          = $arr_datos[0]->score * 100;
        $nombre_titulo  = !empty($arr_datos[0]->nombre_title)? $arr_datos[0]->nombre_title:$arr_datos[0]->title;
        $titulo         = $arr_datos[0]->title;

        $arr_datos_aux = array(
            $arr_datos[0]->nombre_requestedUrl,
            $arr_datos[0]->category,
            $nombre_titulo,
            $score . '%',
            formatoFecha($arr_datos[0]->fecha_registro)
        );
        $html .= armarTRAuditoria($arr_datos_aux, $style);
    }else{
        $score1 = $arr_datos[0]->score;
        $score2 = $arr_datos[1]->score;
        if($score1 > $score2){
            $style_error = 'border:1px solid #ddd; color:#666; padding:5px; background-color:#67FF54;';
        }
        foreach($arr_datos as $ad){
            $score = $ad->score * 100;
            $nombre_titulo  = !empty($ad->nombre_title)? $ad->nombre_title:$ad->title;
            $arr_datos_aux = array(
                $ad->nombre_requestedUrl,
                $ad->category,
                $nombre_titulo,
                $score  . '%',
                formatoFecha($ad->fecha_registro)
            );
            $html .= armarTRAuditoria($arr_datos_aux, $style_error);
        }
    }
    return $html;
}

function formatoFechaSQL($date, $formato = 'Y/m/d H:i:s'){
    $date = DateTime::createFromFormat($formato, $date);
    return $date;
}

function formatoFecha($date, $formato = 'd/m/Y'){
    $fecha_sql = date_create($date);
    return date_format($fecha_sql, $formato);
}